<?php

namespace NumberToWords\NumberTransformer;

class HungarianNumberTransformerTest extends NumberTransformerTest
{
    public function setUp()
    {
        $this->numberTransformer = new HungarianNumberTransformer();
    }

    public function providerItConvertsNumbersToWords()
    {
        return [
            [0, 'nulla'],
            [1, 'egy'],
            [2, 'kettő'],
            [3, 'három'],
            [4, 'négy'],
            [5, 'öt'],
            [6, 'hat'],
            [7, 'hét'],
            [8, 'nyolc'],
            [9, 'kilenc'],
            [11, 'tizenegy'],
            [12, 'tizenkettő'],
            [16, 'tizenhat'],
            [19, 'tizenkilenc'],
            [20, 'húsz'],
            [21, 'huszonegy'],
            [26, 'huszonhat'],
            [30, 'harminc'],
            [31, 'harmincegy'],
            [40, 'negyven'],
            [43, 'negyvenhárom'],
            [50, 'ötven'],
            [55, 'ötvenöt'],
            [60, 'hatvan'],
            [67, 'hatvanhét'],
            [70, 'hetven'],
            [79, 'hetvenkilenc'],
            [100, 'egyszáz'],
            [101, 'egyszázegy'],
            [199, 'egyszázkilencvenkilenc'],
            [203, 'kettőszázhárom'],
            [287, 'kettőszáznyolcvanhét'],
            [300, 'háromszáz'],
            [356, 'háromszázötvenhat'],
            [410, 'négyszáztíz'],
            [434, 'négyszázharmincnégy'],
            [578, 'ötszázhetvennyolc'],
            [689, 'hatszáznyolcvankilenc'],
            [729, 'hétszázhuszonkilenc'],
            [894, 'nyolcszázkilencvennégy'],
            [999, 'kilencszázkilencvenkilenc'],
            [1000, 'egyezer'],
            [1001, 'egyezeregy'],
            [1097, 'egyezerkilencvenhét'],
            [1104, 'egyezeregyszáznégy'],
            [1243, 'egyezerkettőszáznegyvenhárom'],
            [2385, 'kettőezer-háromszáznyolcvanöt'],
            [3766, 'háromezer-hétszázhatvanhat'],
            [4196, 'négyezer-egyszázkilencvenhat'],
            [5846, 'ötezer-nyolcszáznegyvenhat'],
            [6459, 'hatezer-négyszázötvenkilenc'],
            [7232, 'hétezer-kettőszázharminckettő'],
            [8569, 'nyolcezer-ötszázhatvankilenc'],
            [9539, 'kilencezer-ötszázharminckilenc'],
            [1000000, 'egymillió'],
            [1001500, 'egymillió-egyezer-ötszáz'],
            [2000001, 'kettőmillió-egy'],
            [8002001, 'nyolcmillió-kettőezer-egy'],
            [2000000000, 'kettőmilliárd'],
            [0, 'nulla'],
            [1, 'egy'],
            [9, 'kilenc'],
            [10, 'tíz'],
            [11, 'tizenegy'],
            [19, 'tizenkilenc'],
            [20, 'húsz'],
            [21, 'huszonegy'],
            [80, 'nyolcvan'],
            [90, 'kilencven'],
            [99, 'kilencvenkilenc'],
            [100, 'egyszáz'],
            [101, 'egyszázegy'],
            [111, 'egyszáztizenegy'],
            [120, 'egyszázhúsz'],
            [121, 'egyszázhuszonegy'],
            [900, 'kilencszáz'],
            [909, 'kilencszázkilenc'],
            [919, 'kilencszáztizenkilenc'],
            [990, 'kilencszázkilencven'],
            [999, 'kilencszázkilencvenkilenc'],
            [1000, 'egyezer'],
            [1111, 'egyezeregyszáztizenegy'],
            [2000, 'kettőezer'],
            [2001, 'kettőezer-egy'],
            [2111, 'kettőezer-egyszáztizenegy'],
            [4000, 'négyezer'],
            [5000, 'ötezer'],
            [11000, 'tizenegyezer'],
            [21000, 'huszonegyezer'],
            [999000, 'kilencszázkilencvenkilencezer'],
            [999999, 'kilencszázkilencvenkilencezer-kilencszázkilencvenkilenc'],
            [1000000, 'egymillió'],
            [2000000, 'kettőmillió'],
            [4000000, 'négymillió'],
            [5000000, 'ötmillió'],
            [999000000, 'kilencszázkilencvenkilencmillió'],
            [999000999, 'kilencszázkilencvenkilencmillió-kilencszázkilencvenkilenc'],
            [999999000, 'kilencszázkilencvenkilencmillió-kilencszázkilencvenkilencezer'],
            [999999999, 'kilencszázkilencvenkilencmillió-kilencszázkilencvenkilencezer-kilencszázkilencvenkilenc'],
            [1174315110, 'egymilliárd-egyszázhetvennégymillió-háromszáztizenötezer-egyszáztíz'],
            [1174315119, 'egymilliárd-egyszázhetvennégymillió-háromszáztizenötezer-egyszáztizenkilenc'],
            [15174315119, 'tizenötmilliárd-egyszázhetvennégymillió-háromszáztizenötezer-egyszáztizenkilenc'],
            [35174315119, 'harmincötmilliárd-egyszázhetvennégymillió-háromszáztizenötezer-egyszáztizenkilenc'],
            [935174315119, 'kilencszázharmincötmilliárd-egyszázhetvennégymillió-háromszáztizenötezer-egyszáztizenkilenc'],
            [2935174315119, 'kettőbillió-kilencszázharmincötmilliárd-egyszázhetvennégymillió-háromszáztizenötezer-egyszáztizenkilenc'],
            [-2000, 'mínusz kettőezer'],
        ];
    }
}
