<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Notify\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class ServiceOptions {
    /**
     * @param string $friendlyName Human-readable name for this service instance
     * @param string $apnCredentialSid The SID of the Credential to be used for APN
     *                                 Bindings.
     * @param string $gcmCredentialSid The SID of the Credential to be used for GCM
     *                                 Bindings.
     * @param string $messagingServiceSid The SID of the Messaging Service to be
     *                                    used for SMS Bindings.
     * @param string $facebookMessengerPageId The Page ID to be used to send for
     *                                        Facebook Messenger Bindings.
     * @param string $defaultApnNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending APNS
     *                                                      notifications.
     * @param string $defaultGcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending GCM
     *                                                      notifications.
     * @param string $fcmCredentialSid The SID of the Credential to be used for FCM
     *                                 Bindings.
     * @param string $defaultFcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending FCM
     *                                                      notifications.
     * @param boolean $logEnabled The log_enabled
     * @param string $alexaSkillId The alexa_skill_id
     * @param string $defaultAlexaNotificationProtocolVersion The
     *                                                        default_alexa_notification_protocol_version
     * @return CreateServiceOptions Options builder
     */
    public static function create($friendlyName = Values::NONE, $apnCredentialSid = Values::NONE, $gcmCredentialSid = Values::NONE, $messagingServiceSid = Values::NONE, $facebookMessengerPageId = Values::NONE, $defaultApnNotificationProtocolVersion = Values::NONE, $defaultGcmNotificationProtocolVersion = Values::NONE, $fcmCredentialSid = Values::NONE, $defaultFcmNotificationProtocolVersion = Values::NONE, $logEnabled = Values::NONE, $alexaSkillId = Values::NONE, $defaultAlexaNotificationProtocolVersion = Values::NONE) {
        return new CreateServiceOptions($friendlyName, $apnCredentialSid, $gcmCredentialSid, $messagingServiceSid, $facebookMessengerPageId, $defaultApnNotificationProtocolVersion, $defaultGcmNotificationProtocolVersion, $fcmCredentialSid, $defaultFcmNotificationProtocolVersion, $logEnabled, $alexaSkillId, $defaultAlexaNotificationProtocolVersion);
    }

    /**
     * @param string $friendlyName Filter services by FriendlyName
     * @return ReadServiceOptions Options builder
     */
    public static function read($friendlyName = Values::NONE) {
        return new ReadServiceOptions($friendlyName);
    }

    /**
     * @param string $friendlyName Human-readable name for this service instance
     * @param string $apnCredentialSid The SID of the default Credential to be used
     *                                 for APN Bindings
     * @param string $gcmCredentialSid The SID of the default Credential to be used
     *                                 for GCM Bindings
     * @param string $messagingServiceSid The SID of the Messaging Service to be
     *                                    used for SMS Bindings.
     * @param string $facebookMessengerPageId The Page ID to be used to send for
     *                                        Facebook Messenger Bindings.
     * @param string $defaultApnNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending APNS
     *                                                      notifications.
     * @param string $defaultGcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending GCM
     *                                                      notifications.
     * @param string $fcmCredentialSid The SID of the default Credential to be used
     *                                 for FCM Bindings
     * @param string $defaultFcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending FCM
     *                                                      notifications.
     * @param boolean $logEnabled The log_enabled
     * @param string $alexaSkillId The alexa_skill_id
     * @param string $defaultAlexaNotificationProtocolVersion The
     *                                                        default_alexa_notification_protocol_version
     * @return UpdateServiceOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $apnCredentialSid = Values::NONE, $gcmCredentialSid = Values::NONE, $messagingServiceSid = Values::NONE, $facebookMessengerPageId = Values::NONE, $defaultApnNotificationProtocolVersion = Values::NONE, $defaultGcmNotificationProtocolVersion = Values::NONE, $fcmCredentialSid = Values::NONE, $defaultFcmNotificationProtocolVersion = Values::NONE, $logEnabled = Values::NONE, $alexaSkillId = Values::NONE, $defaultAlexaNotificationProtocolVersion = Values::NONE) {
        return new UpdateServiceOptions($friendlyName, $apnCredentialSid, $gcmCredentialSid, $messagingServiceSid, $facebookMessengerPageId, $defaultApnNotificationProtocolVersion, $defaultGcmNotificationProtocolVersion, $fcmCredentialSid, $defaultFcmNotificationProtocolVersion, $logEnabled, $alexaSkillId, $defaultAlexaNotificationProtocolVersion);
    }
}

class CreateServiceOptions extends Options {
    /**
     * @param string $friendlyName Human-readable name for this service instance
     * @param string $apnCredentialSid The SID of the Credential to be used for APN
     *                                 Bindings.
     * @param string $gcmCredentialSid The SID of the Credential to be used for GCM
     *                                 Bindings.
     * @param string $messagingServiceSid The SID of the Messaging Service to be
     *                                    used for SMS Bindings.
     * @param string $facebookMessengerPageId The Page ID to be used to send for
     *                                        Facebook Messenger Bindings.
     * @param string $defaultApnNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending APNS
     *                                                      notifications.
     * @param string $defaultGcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending GCM
     *                                                      notifications.
     * @param string $fcmCredentialSid The SID of the Credential to be used for FCM
     *                                 Bindings.
     * @param string $defaultFcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending FCM
     *                                                      notifications.
     * @param boolean $logEnabled The log_enabled
     * @param string $alexaSkillId The alexa_skill_id
     * @param string $defaultAlexaNotificationProtocolVersion The
     *                                                        default_alexa_notification_protocol_version
     */
    public function __construct($friendlyName = Values::NONE, $apnCredentialSid = Values::NONE, $gcmCredentialSid = Values::NONE, $messagingServiceSid = Values::NONE, $facebookMessengerPageId = Values::NONE, $defaultApnNotificationProtocolVersion = Values::NONE, $defaultGcmNotificationProtocolVersion = Values::NONE, $fcmCredentialSid = Values::NONE, $defaultFcmNotificationProtocolVersion = Values::NONE, $logEnabled = Values::NONE, $alexaSkillId = Values::NONE, $defaultAlexaNotificationProtocolVersion = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['apnCredentialSid'] = $apnCredentialSid;
        $this->options['gcmCredentialSid'] = $gcmCredentialSid;
        $this->options['messagingServiceSid'] = $messagingServiceSid;
        $this->options['facebookMessengerPageId'] = $facebookMessengerPageId;
        $this->options['defaultApnNotificationProtocolVersion'] = $defaultApnNotificationProtocolVersion;
        $this->options['defaultGcmNotificationProtocolVersion'] = $defaultGcmNotificationProtocolVersion;
        $this->options['fcmCredentialSid'] = $fcmCredentialSid;
        $this->options['defaultFcmNotificationProtocolVersion'] = $defaultFcmNotificationProtocolVersion;
        $this->options['logEnabled'] = $logEnabled;
        $this->options['alexaSkillId'] = $alexaSkillId;
        $this->options['defaultAlexaNotificationProtocolVersion'] = $defaultAlexaNotificationProtocolVersion;
    }

    /**
     * Human-readable name for this service instance
     * 
     * @param string $friendlyName Human-readable name for this service instance
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The SID of the [Credential](https://www.twilio.com/docs/notify/api/credentials) to be used for APN Bindings.
     * 
     * @param string $apnCredentialSid The SID of the Credential to be used for APN
     *                                 Bindings.
     * @return $this Fluent Builder
     */
    public function setApnCredentialSid($apnCredentialSid) {
        $this->options['apnCredentialSid'] = $apnCredentialSid;
        return $this;
    }

    /**
     * The SID of the [Credential](https://www.twilio.com/docs/notify/api/credentials) to be used for GCM Bindings.
     * 
     * @param string $gcmCredentialSid The SID of the Credential to be used for GCM
     *                                 Bindings.
     * @return $this Fluent Builder
     */
    public function setGcmCredentialSid($gcmCredentialSid) {
        $this->options['gcmCredentialSid'] = $gcmCredentialSid;
        return $this;
    }

    /**
     * The SID of the [Messaging Service](https://www.twilio.com/docs/api/rest/sending-messages#messaging-services) to be used for SMS Bindings. In order to send SMS notifications this parameter has to be set.
     * 
     * @param string $messagingServiceSid The SID of the Messaging Service to be
     *                                    used for SMS Bindings.
     * @return $this Fluent Builder
     */
    public function setMessagingServiceSid($messagingServiceSid) {
        $this->options['messagingServiceSid'] = $messagingServiceSid;
        return $this;
    }

    /**
     * The Page ID to be used to send for Facebook Messenger Bindings. It has to match the Page ID you configured when you [enabled Facebook Messaging](https://www.twilio.com/console/sms/settings) on your account.
     * 
     * @param string $facebookMessengerPageId The Page ID to be used to send for
     *                                        Facebook Messenger Bindings.
     * @return $this Fluent Builder
     */
    public function setFacebookMessengerPageId($facebookMessengerPageId) {
        $this->options['facebookMessengerPageId'] = $facebookMessengerPageId;
        return $this;
    }

    /**
     * The version of the protocol to be used for sending APNS notifications. Can be overriden on a Binding by Binding basis when creating a [Binding](https://www.twilio.com/docs/notify/api/bindings) resource.
     * 
     * @param string $defaultApnNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending APNS
     *                                                      notifications.
     * @return $this Fluent Builder
     */
    public function setDefaultApnNotificationProtocolVersion($defaultApnNotificationProtocolVersion) {
        $this->options['defaultApnNotificationProtocolVersion'] = $defaultApnNotificationProtocolVersion;
        return $this;
    }

    /**
     * The version of the protocol to be used for sending GCM notifications. Can be overriden on a Binding by Binding basis when creating a [Binding](https://www.twilio.com/docs/notify/api/bindings) resource.
     * 
     * @param string $defaultGcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending GCM
     *                                                      notifications.
     * @return $this Fluent Builder
     */
    public function setDefaultGcmNotificationProtocolVersion($defaultGcmNotificationProtocolVersion) {
        $this->options['defaultGcmNotificationProtocolVersion'] = $defaultGcmNotificationProtocolVersion;
        return $this;
    }

    /**
     * The SID of the [Credential](https://www.twilio.com/docs/notify/api/credentials) to be used for FCM Bindings.
     * 
     * @param string $fcmCredentialSid The SID of the Credential to be used for FCM
     *                                 Bindings.
     * @return $this Fluent Builder
     */
    public function setFcmCredentialSid($fcmCredentialSid) {
        $this->options['fcmCredentialSid'] = $fcmCredentialSid;
        return $this;
    }

    /**
     * The version of the protocol to be used for sending FCM notifications. Can be overriden on a Binding by Binding basis when creating a [Binding](https://www.twilio.com/docs/notify/api/bindings) resource.
     * 
     * @param string $defaultFcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending FCM
     *                                                      notifications.
     * @return $this Fluent Builder
     */
    public function setDefaultFcmNotificationProtocolVersion($defaultFcmNotificationProtocolVersion) {
        $this->options['defaultFcmNotificationProtocolVersion'] = $defaultFcmNotificationProtocolVersion;
        return $this;
    }

    /**
     * The log_enabled
     * 
     * @param boolean $logEnabled The log_enabled
     * @return $this Fluent Builder
     */
    public function setLogEnabled($logEnabled) {
        $this->options['logEnabled'] = $logEnabled;
        return $this;
    }

    /**
     * The alexa_skill_id
     * 
     * @param string $alexaSkillId The alexa_skill_id
     * @return $this Fluent Builder
     */
    public function setAlexaSkillId($alexaSkillId) {
        $this->options['alexaSkillId'] = $alexaSkillId;
        return $this;
    }

    /**
     * The default_alexa_notification_protocol_version
     * 
     * @param string $defaultAlexaNotificationProtocolVersion The
     *                                                        default_alexa_notification_protocol_version
     * @return $this Fluent Builder
     */
    public function setDefaultAlexaNotificationProtocolVersion($defaultAlexaNotificationProtocolVersion) {
        $this->options['defaultAlexaNotificationProtocolVersion'] = $defaultAlexaNotificationProtocolVersion;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Notify.V1.CreateServiceOptions ' . implode(' ', $options) . ']';
    }
}

class ReadServiceOptions extends Options {
    /**
     * @param string $friendlyName Filter services by FriendlyName
     */
    public function __construct($friendlyName = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
    }

    /**
     * Filter services by FriendlyName
     * 
     * @param string $friendlyName Filter services by FriendlyName
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Notify.V1.ReadServiceOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateServiceOptions extends Options {
    /**
     * @param string $friendlyName Human-readable name for this service instance
     * @param string $apnCredentialSid The SID of the default Credential to be used
     *                                 for APN Bindings
     * @param string $gcmCredentialSid The SID of the default Credential to be used
     *                                 for GCM Bindings
     * @param string $messagingServiceSid The SID of the Messaging Service to be
     *                                    used for SMS Bindings.
     * @param string $facebookMessengerPageId The Page ID to be used to send for
     *                                        Facebook Messenger Bindings.
     * @param string $defaultApnNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending APNS
     *                                                      notifications.
     * @param string $defaultGcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending GCM
     *                                                      notifications.
     * @param string $fcmCredentialSid The SID of the default Credential to be used
     *                                 for FCM Bindings
     * @param string $defaultFcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending FCM
     *                                                      notifications.
     * @param boolean $logEnabled The log_enabled
     * @param string $alexaSkillId The alexa_skill_id
     * @param string $defaultAlexaNotificationProtocolVersion The
     *                                                        default_alexa_notification_protocol_version
     */
    public function __construct($friendlyName = Values::NONE, $apnCredentialSid = Values::NONE, $gcmCredentialSid = Values::NONE, $messagingServiceSid = Values::NONE, $facebookMessengerPageId = Values::NONE, $defaultApnNotificationProtocolVersion = Values::NONE, $defaultGcmNotificationProtocolVersion = Values::NONE, $fcmCredentialSid = Values::NONE, $defaultFcmNotificationProtocolVersion = Values::NONE, $logEnabled = Values::NONE, $alexaSkillId = Values::NONE, $defaultAlexaNotificationProtocolVersion = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['apnCredentialSid'] = $apnCredentialSid;
        $this->options['gcmCredentialSid'] = $gcmCredentialSid;
        $this->options['messagingServiceSid'] = $messagingServiceSid;
        $this->options['facebookMessengerPageId'] = $facebookMessengerPageId;
        $this->options['defaultApnNotificationProtocolVersion'] = $defaultApnNotificationProtocolVersion;
        $this->options['defaultGcmNotificationProtocolVersion'] = $defaultGcmNotificationProtocolVersion;
        $this->options['fcmCredentialSid'] = $fcmCredentialSid;
        $this->options['defaultFcmNotificationProtocolVersion'] = $defaultFcmNotificationProtocolVersion;
        $this->options['logEnabled'] = $logEnabled;
        $this->options['alexaSkillId'] = $alexaSkillId;
        $this->options['defaultAlexaNotificationProtocolVersion'] = $defaultAlexaNotificationProtocolVersion;
    }

    /**
     * Human-readable name for this service instance
     * 
     * @param string $friendlyName Human-readable name for this service instance
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The SID of the default Credential to be used for APN Bindings
     * 
     * @param string $apnCredentialSid The SID of the default Credential to be used
     *                                 for APN Bindings
     * @return $this Fluent Builder
     */
    public function setApnCredentialSid($apnCredentialSid) {
        $this->options['apnCredentialSid'] = $apnCredentialSid;
        return $this;
    }

    /**
     * The SID of the default Credential to be used for GCM Bindings
     * 
     * @param string $gcmCredentialSid The SID of the default Credential to be used
     *                                 for GCM Bindings
     * @return $this Fluent Builder
     */
    public function setGcmCredentialSid($gcmCredentialSid) {
        $this->options['gcmCredentialSid'] = $gcmCredentialSid;
        return $this;
    }

    /**
     * The SID of the [Messaging Service](https://www.twilio.com/docs/api/rest/sending-messages#messaging-services) to be used for SMS Bindings. In order to send SMS notifications this parameter has to be set.
     * 
     * @param string $messagingServiceSid The SID of the Messaging Service to be
     *                                    used for SMS Bindings.
     * @return $this Fluent Builder
     */
    public function setMessagingServiceSid($messagingServiceSid) {
        $this->options['messagingServiceSid'] = $messagingServiceSid;
        return $this;
    }

    /**
     * The Page ID to be used to send for Facebook Messenger Bindings. It has to match the Page ID you configured when you [enabled Facebook Messaging](https://www.twilio.com/console/sms/settings) on your account. Facebook Messenger integration is in beta. You need to be in the beta program to be able to enable Facebook Messaging for your account.
     * 
     * @param string $facebookMessengerPageId The Page ID to be used to send for
     *                                        Facebook Messenger Bindings.
     * @return $this Fluent Builder
     */
    public function setFacebookMessengerPageId($facebookMessengerPageId) {
        $this->options['facebookMessengerPageId'] = $facebookMessengerPageId;
        return $this;
    }

    /**
     * The version of the protocol to be used for sending APNS notifications. Can be overriden on a Binding by Binding basis when creating a Binding resource.
     * 
     * @param string $defaultApnNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending APNS
     *                                                      notifications.
     * @return $this Fluent Builder
     */
    public function setDefaultApnNotificationProtocolVersion($defaultApnNotificationProtocolVersion) {
        $this->options['defaultApnNotificationProtocolVersion'] = $defaultApnNotificationProtocolVersion;
        return $this;
    }

    /**
     * The version of the protocol to be used for sending GCM notifications. Can be overriden on a Binding by Binding basis when creating a Binding resource.
     * 
     * @param string $defaultGcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending GCM
     *                                                      notifications.
     * @return $this Fluent Builder
     */
    public function setDefaultGcmNotificationProtocolVersion($defaultGcmNotificationProtocolVersion) {
        $this->options['defaultGcmNotificationProtocolVersion'] = $defaultGcmNotificationProtocolVersion;
        return $this;
    }

    /**
     * The SID of the default Credential to be used for FCM Bindings
     * 
     * @param string $fcmCredentialSid The SID of the default Credential to be used
     *                                 for FCM Bindings
     * @return $this Fluent Builder
     */
    public function setFcmCredentialSid($fcmCredentialSid) {
        $this->options['fcmCredentialSid'] = $fcmCredentialSid;
        return $this;
    }

    /**
     * The version of the protocol to be used for sending FCM notifications. Can be overriden on a Binding by Binding basis when creating a Binding resource.
     * 
     * @param string $defaultFcmNotificationProtocolVersion The version of the
     *                                                      protocol to be used for
     *                                                      sending FCM
     *                                                      notifications.
     * @return $this Fluent Builder
     */
    public function setDefaultFcmNotificationProtocolVersion($defaultFcmNotificationProtocolVersion) {
        $this->options['defaultFcmNotificationProtocolVersion'] = $defaultFcmNotificationProtocolVersion;
        return $this;
    }

    /**
     * The log_enabled
     * 
     * @param boolean $logEnabled The log_enabled
     * @return $this Fluent Builder
     */
    public function setLogEnabled($logEnabled) {
        $this->options['logEnabled'] = $logEnabled;
        return $this;
    }

    /**
     * The alexa_skill_id
     * 
     * @param string $alexaSkillId The alexa_skill_id
     * @return $this Fluent Builder
     */
    public function setAlexaSkillId($alexaSkillId) {
        $this->options['alexaSkillId'] = $alexaSkillId;
        return $this;
    }

    /**
     * The default_alexa_notification_protocol_version
     * 
     * @param string $defaultAlexaNotificationProtocolVersion The
     *                                                        default_alexa_notification_protocol_version
     * @return $this Fluent Builder
     */
    public function setDefaultAlexaNotificationProtocolVersion($defaultAlexaNotificationProtocolVersion) {
        $this->options['defaultAlexaNotificationProtocolVersion'] = $defaultAlexaNotificationProtocolVersion;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Notify.V1.UpdateServiceOptions ' . implode(' ', $options) . ']';
    }
}